Config                            = {}

---------------------------------------------------------------------------------------------------------------------------------------------------------
-- [Command Settings]

-- NOTE: If These Are Changed you Must Manually Change The Suggestions Found in "c_zoneframework/c_coms.lua"

-- Input Command Name (args[0])
Config.CommandName = 'zone'

-- Clear Zone Name (args[1])
Config.ClearZoneName = 'clear'

-- Stop Zone Name (args[1])
Config.StopZoneName = 'stop'

-- Slow Zone Name (args[1])
Config.SlowZoneName = 'slow'

---------------------------------------------------------------------------------------------------------------------------------------------------------
-- [Blip/Zone Settings]

-- Blip Transparency (-/+ For Effect)
Config.BlipAlpha = 80

-- Slow Blip Color
Config.BlipColorSlow = 47

-- Stop Blip Color
Config.BlipColorStop = 1

-- Radius Blip Will Display / Zone Affectivness Radius (Float Value)
Config.Radius = 30.0

-- Designated Speed For Slow Zone (Float Value)
Config.SlowZoneSpeed = 5.0

---------------------------------------------------------------------------------------------------------------------------------------------------------
-- [Blip Notification Settings]

-- Toggles Notify Display
Config.EnableNotifications = true

-- Limitation Error Text
Config.LimitErrorNotify = "~w~You May Only Have ".. "~y~One Active " .. "~w~Zone."

-- Slow Zone Activation Text
Config.ZoneSlowNotify = "~y~Slow " .. "~w~Zone Activated"

-- Stop Zone Activation Notify
Config.ZoneStopNotify = "~r~Stop " .. "~w~Zone Activated"

-- Clear Zones Notify
Config.ZoneClearNotify = "~y~Zone " .. "~w~Deactivated"

---------------------------------------------------------------------------------------------------------------------------------------------------------
-- [Chat Message Settings]

-- Toggles Chat Message
Config.EnableChatMsg = true

-- Name Of Sender
Config.MessageSender = "ZONE CNTRL | "

-- Color Of Message (R/G/B)
Config.SenderColor = {220, 84, 42}

-- Clear Zone Message Text
Config.ClearMessage = "Active Zone Cleared."

-- Stop Zone Message Text
Config.StopMessage = "You Have Set A Stop Zone Use /zone clear To Delete It."

-- Slow Zone Message Text
Config.SlowMessage = "You Have Set A Slow Zone Use /zone clear To Delete It."



Config.DrawDistance               = 10.0 -- How close do you need to be for the markers to be drawn (in GTA units).
Config.MarkerType                 = {Cloakrooms = 20, Armories = 21, BossActions = 22, Vehicles = 36, Helicopters = 34}
Config.MarkerSize                 = {x = 1.5, y = 1.5, z = 0.5}
Config.MarkerColor                = {r = 50, g = 50, b = 204}

Config.EnablePlayerManagement     = true -- Enable if you want society managing.
Config.EnableArmoryManagement     = true
Config.EnableESXIdentity          = true -- Enable if you're using esx_identity.
Config.EnableLicenses             = true -- Enable if you're using esx_license.

Config.EnableHandcuffTimer        = false -- Enable handcuff timer? will unrestrain player after the time ends.
Config.HandcuffTimer              = 10 * 60000 -- 10 minutes.

Config.EnableJobBlip              = true  -- Enable blips for cops on duty, requires esx_society.
Config.EnableCustomPeds           = false -- Enable custom peds in cloak room? See Config.CustomPeds below to customize peds.

Config.EnableESXService           = true -- Enable esx service?
Config.MaxInService               = -1 -- How much people can be in service at once?

Config.Grappler                   = false -- Wenn ihr das Grappler Skript haben solltet könnt ihr das hier einfacher abrufen.
Config.Pepperspray                = false -- Wenn ihr das Pfefferspray Skript haben solltet könnt ihr das hier einfacher abrufen.

Config.Locale                     = 'de'

Config.PoliceStations = {

	LSPD = {

		Blip = {
			Coords  = vector3(425.1, -979.5, 30.7),
			Sprite  = 60,
			Display = 4,
			Scale   = 1.2,
			Colour  = 29
		},

		Cloakrooms = {
			vector3(462.3, -999.6, 30.6),
			vector3(1849.3, 3696.4, 34.0),
			vector3(435.6575, -975.8024, 30.7173),
		},

		Armories = {
			vector3(479.2, -996.9, 30.6),
			vector3(1845.8, 3692.5, 34.2),
			vector3(435.5021, -973.3425, 30.7136),
		},

		Vehicles = {
			{
				Spawner = vector3(459.1, -986.7, 25.9),
				InsideShop = vector3(458.9, -992.2, 25.7),
				SpawnPoints = {
					{coords = vector3(450.6, -975.6, 25.7), heading = 90.0, radius = 6.0},
					{coords = vector3(436.4, -975.7, 25.7), heading = 90.0, radius = 6.0}
				}
			},

			{
				Spawner = vector3(473.3, -1018.8, 28.0),
				InsideShop = vector3(228.5, -993.5, -99.0),
				SpawnPoints = {
					{coords = vector3(475.9, -1021.6, 28.0), heading = 276.1, radius = 6.0},
					{coords = vector3(484.1, -1023.1, 27.5), heading = 302.5, radius = 6.0}
				}
			},


			{
				Spawner = vector3(432.8987, -986.0208, 30.7101),
				InsideShop = vector3(458.9, -992.2, 25.7),
				SpawnPoints = {
					{coords = vector3(450.6, -975.6, 25.7), heading = 90.0, radius = 6.0},
					{coords = vector3(436.4, -975.7, 25.7), heading = 90.0, radius = 6.0}
				}
			}
		},

		Helicopters = {
			{
				Spawner = vector3(461.1, -981.5, 43.6),
				InsideShop = vector3(477.0, -1106.4, 43.0),
				SpawnPoints = {
					{coords = vector3(449.5, -981.2, 43.6), heading = 92.6, radius = 10.0}
				}
			}
		},
		BossActions = {
			vector3(460.74, -985.55, 30.7),
		}

	}

}

Config.AuthorizedWeapons = {

	recruit = {
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	ka = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0}
	},

	pk = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	},


	pok = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	},


	phk = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	},

	phka = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	},

	ephk = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	},


	pr = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	},

	por = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	},

	pd = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	},

	
	lpd = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	},

	kd = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	},

	dlob = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	},

	idp = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	},

	pvp = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	},

	ppt = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	},

	boss = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0},
		{weapon = 'WEAPON_COMBATPISTOL', price = 0},
		{weapon = 'WEAPON_SMG', price = 0}
	}

}

Config.AuthorizedVehicles = {
	car = {
		recruit = {},

		ka = {
			{model = 'code310charg', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1}
		},

		pk = {
			{model = 'code316impala', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1}
		},

		pok = {
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1}
		},
		
		phk = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3bmw', price = 1}
		},

		phka = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3bmw', price = 1}
		},

		ephk = {
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1}
		},

		pr = {
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1}
		},

		por = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1}
		},


		pd = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3bmw', price = 1}
		},

		lpd = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		},

		kd = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		},

		dlob = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		},

		idp = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		},

		pvp = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		},

		ppt = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		},

		boss = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoek9', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318chargk9', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3harley', price = 1},
			{model = 'code3gator', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		}
	},

	helicopter = {
		recruit = {},

		ka = {},

		pk = {},

		pok = {},

		phk = {},

		phka = {},

		ephk = {},

		pr = {},

		por = {},

		pd = {
		},

		lpd = {
		},

		kd = {
		},

		dlob = {
		},

		idp = {
		},

		pvp = {
		},

		ppt = {
			{model = 'polmav', props = {modLivery = 0}, price = 200000}
		},

		boss = {
			{model = 'polmav', props = {modLivery = 0}, price = 100000}
		}
	}
}

Config.CustomPeds = {
	shared = {
		{label = 'Sheriff Ped', maleModel = 's_m_y_sheriff_01', femaleModel = 's_f_y_sheriff_01'},
		{label = 'Police Ped', maleModel = 's_m_y_cop_01', femaleModel = 's_f_y_cop_01'}
	},

	recruit = {},

	ka = {},

	pk = {},

	pok = {},

	phk = {},

	phka = {},

	ephk = {},

	pr = {},

	por = {},

	pd = {},

	lpd = {},

	kd = {},

	dlob = {},

	idp = {},

	pvp = {},

	ppt = {},

	boss = {
		{label = 'SWAT Ped', maleModel = 's_m_y_swat_01', femaleModel = 's_m_y_swat_01'}
	}
}

-- CHECK SKINCHANGER CLIENT MAIN.LUA for matching elements
Config.Uniforms = {
	recruit = {
		male = {
			tshirt_1 = 36,  tshirt_2 = 1,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 73,   decals_2 = 0,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 36,  tshirt_2 = 1,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = 45,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0,
		}
	},

	ka = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 73,   decals_2 = 7,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pk = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 73,   decals_2 = 8,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pok = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 73,   decals_2 = 9,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	phk = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 73,   decals_2 = 10,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 1,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	phka = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 71,   decals_2 = 0,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 1,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	ephk = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 71,   decals_2 = 1,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pr = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 71,   decals_2 = 3,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	por = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 71,   decals_2 = 4,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pd = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 71,   decals_2 = 5,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 2,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	lpd = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 71,   decals_2 = 6,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 2,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	kd = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 71,   decals_2 = 7,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 2,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},
	
	dlob = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 71,   decals_2 = 8,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 2,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	idp = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 71,   decals_2 = 9,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 2,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pvp = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 71,   decals_2 = 10,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 2,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	ppt = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 73,   decals_2 = 7,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 2,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	boss = {
		male = {
			tshirt_1 = 159,  tshirt_2 = 0,
			torso_1 = 299,   torso_2 = 3,
			decals_1 = 71,   decals_2 = 10,
			arms = 92,
			pants_1 = 115,   pants_2 = 2,
			shoes_1 = 91,   shoes_2 = 1,
			helmet_1 = 140,  helmet_2 = 3,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 3,
			arms = 44,
			pants_1 = 34,   pants_2 = 2,
			shoes_1 = 27,   shoes_2 = 1,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		},
	},

	bullet_wear = {
		male = {
			bproof_1 = 46,  bproof_2 = 0
		},
		female = {
			bproof_1 = 13,  bproof_2 = 1
		}
	},

	bullet_wear_2 = {
		male = {
			bproof_1 = 46,  bproof_2 = 1
		},
		female = {
			bproof_1 = 13,  bproof_2 = 1
		}
	},

	bullet_wear_3 = {
		male = {
			torso_1 = 298,   torso_2 = 0
		},
		female = {
			torso_1 = 298,   torso_2 = 0
		}
	},

	bullet_wear_4 = {
		male = {
			torso_1 = 303,   torso_2 = 3
		},
		female = {
			torso_1 = 303,   torso_2 = 3
		}
	},

	bullet_wear_5 = {
		male = {
			torso_1 = 307,   torso_2 = 3
		},
		female = {
			torso_1 = 307,   torso_2 = 3
		}
	},

	body_radio_cam = {
		male = {
			bproof_1 = 16,  bproof_2 = 0
		},
		female = {
			bproof_1 = 13,  bproof_2 = 1
		}
	},

	gilet_wear = {
		male = {
			bproof_1 = 47,  bproof_2 = 1
		},
		female = {
			bproof_1 = 36,  bproof_2 = 1
		}
	}
}
