Config                            = {}

---------------------------------------------------------------------------------------------------------------------------------------------------------
-- [Command Settings]

-- NOTE: If These Are Changed you Must Manually Change The Suggestions Found in "c_zoneframework/c_coms.lua"

-- Input Command Name (args[0])
Config.CommandName = 'zone'

-- Clear Zone Name (args[1])
Config.ClearZoneName = 'clear'

-- Stop Zone Name (args[1])
Config.StopZoneName = 'stop'

-- Slow Zone Name (args[1])
Config.SlowZoneName = 'slow'

---------------------------------------------------------------------------------------------------------------------------------------------------------
-- [Blip/Zone Settings]

-- Blip Transparency (-/+ For Effect)
Config.BlipAlpha = 80

-- Slow Blip Color
Config.BlipColorSlow = 47

-- Stop Blip Color
Config.BlipColorStop = 1

-- Radius Blip Will Display / Zone Affectivness Radius (Float Value)
Config.Radius = 30.0

-- Designated Speed For Slow Zone (Float Value)
Config.SlowZoneSpeed = 5.0

---------------------------------------------------------------------------------------------------------------------------------------------------------
-- [Blip Notification Settings]

-- Toggles Notify Display
Config.EnableNotifications = true

-- Limitation Error Text
Config.LimitErrorNotify = "~w~You May Only Have ".. "~y~One Active " .. "~w~Zone."

-- Slow Zone Activation Text
Config.ZoneSlowNotify = "~y~Slow " .. "~w~Zone Activated"

-- Stop Zone Activation Notify
Config.ZoneStopNotify = "~r~Stop " .. "~w~Zone Activated"

-- Clear Zones Notify
Config.ZoneClearNotify = "~y~Zone " .. "~w~Deactivated"

---------------------------------------------------------------------------------------------------------------------------------------------------------
-- [Chat Message Settings]

-- Toggles Chat Message
Config.EnableChatMsg = true

-- Name Of Sender
Config.MessageSender = "ZONE CNTRL | "

-- Color Of Message (R/G/B)
Config.SenderColor = {220, 84, 42}

-- Clear Zone Message Text
Config.ClearMessage = "Active Zone Cleared."

-- Stop Zone Message Text
Config.StopMessage = "You Have Set A Stop Zone Use /zone clear To Delete It."

-- Slow Zone Message Text
Config.SlowMessage = "You Have Set A Slow Zone Use /zone clear To Delete It."



Config.DrawDistance               = 10.0 -- How close do you need to be for the markers to be drawn (in GTA units).
Config.MarkerType                 = {Cloakrooms = 20, Armories = 21, BossActions = 22, Vehicles = 36, Helicopters = 34}
Config.MarkerSize                 = {x = 1.5, y = 1.5, z = 0.5}
Config.MarkerColor                = {r = 50, g = 50, b = 204}

Config.EnablePlayerManagement     = true -- Enable if you want society managing.
Config.EnableArmoryManagement     = true
Config.EnableESXIdentity          = true -- Enable if you're using esx_identity.
Config.EnableLicenses             = true -- Enable if you're using esx_license.

Config.EnableHandcuffTimer        = false -- Enable handcuff timer? will unrestrain player after the time ends.
Config.HandcuffTimer              = 10 * 60000 -- 10 minutes.

Config.EnableJobBlip              = true  -- Enable blips for cops on duty, requires esx_society.
Config.EnableCustomPeds           = false -- Enable custom peds in cloak room? See Config.CustomPeds below to customize peds.

Config.EnableESXService           = true -- Enable esx service?
Config.MaxInService               = -1 -- How much people can be in service at once?

Config.Grappler                   = false -- Wenn ihr das Grappler Skript haben solltet könnt ihr das hier einfacher abrufen.
Config.Pepperspray                = false -- Wenn ihr das Pfefferspray Skript haben solltet könnt ihr das hier einfacher abrufen.

Config.Locale                     = 'de'

Config.PoliceStations = {

	LSPD = {

		Blip = {
			Coords  = vector3(425.1, -979.5, 30.7),
			Sprite  = 60,
			Display = 4,
			Scale   = 1.2,
			Colour  = 29
		},

		Cloakrooms = {
			vector3(462.3, -999.6, 30.6),
			vector3(1849.3, 3696.4, 34.0),
		},

		Armories = {
			vector3(479.2, -996.9, 30.6),
			vector3(1845.8, 3692.5, 34.2),
		},

		Vehicles = {
			{
				Spawner = vector3(459.1, -986.7, 25.9),
				InsideShop = vector3(458.9, -992.2, 25.7),
				SpawnPoints = {
					{coords = vector3(450.6, -975.6, 25.7), heading = 90.0, radius = 6.0},
					{coords = vector3(436.4, -975.7, 25.7), heading = 90.0, radius = 6.0}
				}
			},

			{
				Spawner = vector3(473.3, -1018.8, 28.0),
				InsideShop = vector3(228.5, -993.5, -99.0),
				SpawnPoints = {
					{coords = vector3(475.9, -1021.6, 28.0), heading = 276.1, radius = 6.0},
					{coords = vector3(484.1, -1023.1, 27.5), heading = 302.5, radius = 6.0}
				}
			}
		},

		Helicopters = {
			{
				Spawner = vector3(461.1, -981.5, 43.6),
				InsideShop = vector3(477.0, -1106.4, 43.0),
				SpawnPoints = {
					{coords = vector3(449.5, -981.2, 43.6), heading = 92.6, radius = 10.0}
				}
			}
		},
		BossActions = {
			vector3(460.74, -985.55, 30.7),
		}

	}

}

Config.AuthorizedWeapons = {
	recruit = {
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	pdor1 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},


	pdor2 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},


	pdor3 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},

		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	pdsg1 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	pdsg2 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},


	pddv1 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	pddv2 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	pddv3 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	
	pdlt1 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_CARBINERIFLE', price = 0},
		{weapon = 'WEAPON_PUMPSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_COMBATSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	pdlt2 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_CARBINERIFLE', price = 0},
		{weapon = 'WEAPON_PUMPSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_COMBATSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	pdcp1 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_CARBINERIFLE', price = 0},
		{weapon = 'WEAPON_PUMPSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_COMBATSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	pdcp2 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_CARBINERIFLE', price = 0},
		{weapon = 'WEAPON_PUMPSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_COMBATSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	pdcp3 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_CARBINERIFLE', price = 0},
		{weapon = 'WEAPON_PUMPSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_COMBATSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	pdcm1 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 10000},
		{weapon = 'WEAPON_CARBINERIFLE', price = 0},
		{weapon = 'WEAPON_PUMPSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_COMBATSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	pddc1 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_CARBINERIFLE', price = 0},
		{weapon = 'WEAPON_PUMPSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_COMBATSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	pddc2 = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_CARBINERIFLE', price = 0},
		{weapon = 'WEAPON_PUMPSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_COMBATSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	},

	boss = {
		{weapon = 'WEAPON_PISTOL_MK2', components = {0, 0, 0, 0, nil}, price = 0},
		{weapon = 'WEAPON_CARBINERIFLE', price = 0},
		{weapon = 'WEAPON_PUMPSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_COMBATSHOTGUN', components = {0, 0, nil}, price = 0},
		{weapon = 'WEAPON_NIGHTSTICK', price = 0},
		{weapon = 'WEAPON_STUNGUN', price = 0},
		{weapon = 'WEAPON_FLASHLIGHT', price = 0}
	}
}

Config.AuthorizedVehicles = {
	car = {
		recruit = {},

		pdor1 = {
			{model = 'code310charg', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1}
		},

		pdor2 = {
			{model = 'code316impala', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1}
		},

		pdor3 = {
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1}
		},
		
		pdsg1 = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3bmw', price = 1}
		},

		pdsg2 = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3bmw', price = 1}
		},

		pddv1 = {
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1}
		},

		pddv2 = {
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1}
		},

		pddv3 = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1}
		},


		pdlt1 = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3bmw', price = 1}
		},

		pdlt2 = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		},

		pdcp1 = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		},

		pdcp2 = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3gator', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		},

		pdcp3 = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3gator', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		},

		pdcm1 = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3gator', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		},

		pddc1 = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3gator', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		},

		pddc2 = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3gator', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		},

		boss = {
			{model = 'code320exp', price = 1},
			{model = 'code319silv', price = 1},
			{model = 'code318tahoek9', price = 1},
			{model = 'code318tahoe', price = 1},
			{model = 'code318chargk9', price = 1},
			{model = 'code318charg', price = 1},
			{model = 'code316impala', price = 1},
			{model = 'code316fpiu', price = 1},
			{model = 'code314tahoe', price = 1},
			{model = 'code314charg', price = 1},
			{model = 'code310charg', price = 1},
			{model = 'code3mustang', price = 1},
			{model = 'code3harley', price = 1},
			{model = 'code3gator', price = 1},
			{model = 'code3fpis', price = 1},
			{model = 'code3f250', price = 1},
			{model = 'code3f150', price = 1},
			{model = 'code3ram', price = 1},
			{model = 'code3durango', price = 1},
			{model = 'code3cvpi', price = 1},
			{model = 'code3cap', price = 1},
			{model = 'code3camero', price = 1},
			{model = 'code3bmw', price = 1}
		}
	},

	helicopter = {
		recruit = {},

		pdor1 = {},

		pdor2 = {},

		pdor3 = {},

		pdsg1 = {},

		pdsg2 = {},

		pddv1 = {},

		pddv2 = {},

		pddv3 = {},

		pdlt1 = {
			{model = 'polmav', props = {modLivery = 0}, price = 200000}
		},

		pdlt2 = {
			{model = 'polmav', props = {modLivery = 0}, price = 200000}
		},

		pdcp1 = {
			{model = 'polmav', props = {modLivery = 0}, price = 200000}
		},

		pdcp2 = {
			{model = 'polmav', props = {modLivery = 0}, price = 200000}
		},

		pdcp3 = {
			{model = 'polmav', props = {modLivery = 0}, price = 200000}
		},

		pdcm1 = {
			{model = 'polmav', props = {modLivery = 0}, price = 200000}
		},

		pddc1 = {
			{model = 'polmav', props = {modLivery = 0}, price = 200000}
		},

		pddc2 = {
			{model = 'polmav', props = {modLivery = 0}, price = 200000}
		},

		boss = {
			{model = 'polmav', props = {modLivery = 0}, price = 100000}
		}
	}
}

Config.CustomPeds = {
	shared = {
		{label = 'Sheriff Ped', maleModel = 's_m_y_sheriff_01', femaleModel = 's_f_y_sheriff_01'},
		{label = 'Police Ped', maleModel = 's_m_y_cop_01', femaleModel = 's_f_y_cop_01'}
	},

	recruit = {},

	pdor1 = {},
	
	pdor2 = {},

	pdor3 = {},

	pdsg1 = {},

	pdsg2 = {},

	pddv1 = {},

	pddv2 = {},

	pddv3 = {},

	pdlt1 = {},
	
	pdlt2 = {},

	pdcp1 = {},

	pdcp2 = {},

	pdcp3 = {},

	pdcm1 = {},

	pddc1 = {},

	pddc2 = {},

	boss = {
		{label = 'SWAT Ped', maleModel = 's_m_y_swat_01', femaleModel = 's_m_y_swat_01'}
	}
}

-- CHECK SKINCHANGER CLIENT MAIN.LUA for matching elements
Config.Uniforms = {
	recruit = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 55,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 41,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 46,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0,
			bproof_1 = 18,  bproof_2 = 7
		},
		female = {
			tshirt_1 = 36,  tshirt_2 = 1,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = 45,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0,
			bproof_1 = 16,  bproof_2 = 0
		}
	},

	pdor1 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 209,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pdor2 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 209,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pdor3 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 209,   torso_2 = 0,
			decals_1 = 12,   decals_2 = 0,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pdsg1 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 209,   torso_2 = 0,
			decals_1 = 12,   decals_2 = 2,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 1,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pdsg2 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 209,   torso_2 = 0,
			decals_1 = 12,   decals_2 = 3,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 1,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pddv1 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 209,   torso_2 = 0,
			decals_1 = 12,   decals_2 = 4,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pddv2 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 209,   torso_2 = 0,
			decals_1 = 12,   decals_2 = 5,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pddv3 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 209,   torso_2 = 0,
			decals_1 = 12,   decals_2 = 6,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 0,   decals_2 = 0,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pdlt1 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 255,   torso_2 = 0,
			decals_1 = 45,   decals_2 = 0,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 2,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pdlt2 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 255,   torso_2 = 1,
			decals_1 = 45,   decals_2 = 0,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 2,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pdcp1 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 255,   torso_2 = 2,
			decals_1 = 45,   decals_2 = 1,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 2,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pdcp2 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 255,   torso_2 = 3,
			decals_1 = 45,   decals_2 = 1,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 2,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pdcp3 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 255,   torso_2 = 4,
			decals_1 = 45,   decals_2 = 1,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 2,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		}
	},

	pdcm1 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 255,   torso_2 = 5,
			decals_1 = 45,   decals_2 = 2,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 3,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		},
	},

	pddc1 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 255,   torso_2 = 5,
			decals_1 = 45,   decals_2 = 3,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 3,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		},
	},

	pddc2 = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 255,   torso_2 = 5,
			decals_1 = 45,   decals_2 = 4,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 3,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		},
	},

	boss = {
		male = {
			tshirt_1 = 214,  tshirt_2 = 0,
			torso_1 = 255,   torso_2 = 5,
			decals_1 = 45,   decals_2 = 5,
			arms = 17,
			pants_1 = 25,   pants_2 = 6,
			shoes_1 = 51,   shoes_2 = 0,
			helmet_1 = 75,  helmet_2 = 2,
			chain_1 = 8,    chain_2 = 0,
			ears_1 = 33,     ears_2 = 0
		},
		female = {
			tshirt_1 = 35,  tshirt_2 = 0,
			torso_1 = 48,   torso_2 = 0,
			decals_1 = 7,   decals_2 = 3,
			arms = 44,
			pants_1 = 34,   pants_2 = 0,
			shoes_1 = 27,   shoes_2 = 0,
			helmet_1 = -1,  helmet_2 = 0,
			chain_1 = 0,    chain_2 = 0,
			ears_1 = 2,     ears_2 = 0
		},
	},

	bullet_wear = {
		male = {
			bproof_1 = 59,  bproof_2 = 0
		},
		female = {
			bproof_1 = 13,  bproof_2 = 1
		}
	},

	bullet_wear_2 = {
		male = {
			bproof_1 = 58,  bproof_2 = 0
		},
		female = {
			bproof_1 = 13,  bproof_2 = 1
		}
	},

	bullet_wear_3 = {
		male = {
			bproof_1 = 62,  bproof_2 = 0
		},
		female = {
			bproof_1 = 13,  bproof_2 = 1
		}
	},

	bullet_wear_4 = {
		male = {
			bproof_1 = 60,  bproof_2 = 0
		},
		female = {
			bproof_1 = 13,  bproof_2 = 1
		}
	},

	bullet_wear_5 = {
		male = {
			bproof_1 = 4,  bproof_2 = 0
		},
		female = {
			bproof_1 = 13,  bproof_2 = 1
		}
	},

	body_radio_cam = {
		male = {
			bproof_1 = 16,  bproof_2 = 0
		},
		female = {
			bproof_1 = 13,  bproof_2 = 1
		}
	},

	gilet_wear = {
		male = {
			bproof_1 = 18,  bproof_2 = 7
		},
		female = {
			bproof_1 = 36,  bproof_2 = 1
		}
	}
}
